

rm(list=ls())

source("Packages.R")

###################################################################################################################
####################### READ AND PREPARE GENERAL VARS #############################################################
###################################################################################################################

# source("C:/Dropbox/Dataset/Indikator Politik Indonesia/Surnas_Indikator_Januari 2020 Prepare Vars.R")
# 
# cols_tokeep = c("exp_1", "v_8_a", "v_8_b", "v_8_c", "v_8_d", "weight", 
#                 "muslim", "female", "age", "edu", "income", 
#                 "jokowi2019", "satisfaction",
#                 "islamicparty2019", "considerrel", "javaisland", "urban")
# 
# dat = dat[, cols_tokeep]
# 
# save(dat, file="January 2020.dat")


###################################################################################################################
## JANUARY 2020 EXPERIMENT
###################################################################################################################

rm(list=ls())
load("January 2020.dat")

## independent variable
dat$exp_1 = as.factor(dat$exp_1)
dat$group[dat$exp_1 == 1] = "ulema - corrupt"
dat$group[dat$exp_1 == 2] = "ulema - nocorrupt"
dat$group[dat$exp_1 == 3] = "no ulema - corrupt"
dat$group[dat$exp_1 == 4] = "no ulema - no corrupt"
dat$group = as.factor(dat$group)

dat$corrupt = ifelse(dat$exp_1 %in% c(1,3), 1, 0)
dat$ulema = ifelse(dat$exp_1 %in% c(1,2), 1, 0)


## dependent variable: 
dat$vote[dat$exp_1 == 1] = dat$v_8_a[dat$exp_1 == 1]
dat$vote[dat$exp_1 == 2] = dat$v_8_b[dat$exp_1 == 2]
dat$vote[dat$exp_1 == 3] = dat$v_8_c[dat$exp_1 == 3]
dat$vote[dat$exp_1 == 4] = dat$v_8_d[dat$exp_1 == 4]
dat$vote = car::recode(dat$vote, "1=0; 2=1; 8=NA")

## create survey data
svydat = svydesign(id=~1, data=dat, weights = dat$weight)
svydat.muslim = subset(svydat, subset=(muslim==1))


###################################################################################################################
## Balance Check
###################################################################################################################

sink("Balance Check January 2020.txt")
# female
print("Female ==========")
summary(aov(female ~ group, subset(dat, muslim==1)))

# age
print("Age ==========")
summary(aov(age ~ group, subset(dat, muslim==1)))

# edu
print("Education ==========")
summary(aov(edu ~ group, subset(dat, muslim==1)))

# income
print("Income ==========")
summary(aov(income ~ group, subset(dat, muslim==1)))

# jokowi2019
print("Jokowi 2019 ==========")
summary(aov(jokowi2019 ~ group, subset(dat, muslim==1)))

# satisfaction
print("Satisfaction ==========")
summary(aov(satisfaction ~ group, subset(dat, muslim==1)))

# islamicparty
print("Islamic Party 2019 ==========")
summary(aov(islamicparty2019 ~ group, subset(dat, muslim==1)))

# considerrel
print("Consider Religion ==========")
summary(aov(considerrel ~ group, subset(dat, muslim==1)))

sink(NULL)


###################################################################################################################
## FUNCTIONS TO PLOT INTERACTION
###################################################################################################################

plot.main.effect <- function(plot.main, title, title.size, legend.title.size, lab.y, ylim) {
  plot.out <-
    plot.main +
    geom_errorbar(aes(ymin=Estimate - 1.96*se, ymax=Estimate + 1.96*se), 
                  width=.1, lwd=.7, position = position_dodge(width = .3)) +
    geom_point(size=2, fill="black", position = position_dodge(width = .3)) +
    theme_bw() + 
    theme(legend.text=element_text(size=legend.title.size), plot.title = element_text(size=title.size)) + 
    ylab(lab.y) +
    xlab("") +
    theme(axis.title.x = element_text(size = 12)) +
    theme(axis.title.y = element_text(size = 12)) +
    theme(axis.text.x = element_text(size = 12)) +
    theme(axis.text.y = element_text(size = 12)) +
    ylim(ylim[1], ylim[2]) +
    ggtitle(title)

  return (plot.out)
}


plot.int2 <- function(plot.main, title, obj, obj.label, pos.legend, legend.title.size, legend.label.size, lab.y, ylim, size.x=15, size.y=15) {
  plot.out <-
    plot.main +
    geom_errorbar(aes(ymin=Estimate - 1.96*se, ymax=Estimate + 1.96*se, col=obj), 
                  width=.1, lwd=1, position = position_dodge(width = .3)) +
    geom_point(aes(col=obj, pch=obj), 
               size=4, fill="black", position = position_dodge(width = .3)) +
    theme_bw() + 
    ylab(lab.y) +
    xlab("") +
    theme(axis.title.x = element_text(size = size.x)) +
    theme(axis.title.y = element_text(size = size.y)) +
    theme(axis.text.x = element_text(size = size.x)) +
    theme(axis.text.y = element_text(size = size.y)) +
    coord_cartesian(ylim=c(ylim[1], ylim[2])) + 
    theme(legend.text=element_text(size=legend.label.size)) + 
    guides(pch=guide_legend(obj.label, title.theme = element_text(size=legend.title.size), reverse=TRUE), 
           col=guide_legend(obj.label, title.theme = element_text(size=legend.title.size), reverse=TRUE)) +
    theme(legend.position = pos.legend) + 
    theme(legend.background = element_rect(fill="white", 
                                           size=.1, linetype="solid")) + 
    ggtitle(title)
  
  return (plot.out)
}


plot.int2bar <- function(plot.main, title, obj, obj.label, pos.legend, legend.title.size, legend.label.size, lab.y, ylim, size.x=15, size.y=15) {
  plot.out <-
    plot.main +
    geom_bar(stat = "identity", position = position_dodge(width = .92)) +
    geom_errorbar(aes(ymin=Estimate - 1.96*se, ymax=Estimate + 1.96*se), 
                  width=.1, lwd=1, position = position_dodge(width = .92)) +
    theme_bw() + 
    ylab(lab.y) +
    xlab("") +
    theme(axis.title.x = element_text(size = size.x)) +
    theme(axis.title.y = element_text(size = size.y)) +
    theme(axis.text.x = element_text(size = size.x)) +
    theme(axis.text.y = element_text(size = size.y)) +
    coord_cartesian(ylim=c(ylim[1], ylim[2])) + 
    theme(legend.text=element_text(size=legend.label.size)) + 
    guides(pch=guide_legend(obj.label, title.theme = element_text(size=legend.title.size), reverse=TRUE), 
           col=guide_legend(obj.label, title.theme = element_text(size=legend.title.size), reverse=TRUE)) +
    theme(legend.position = pos.legend) + 
    theme(legend.background = element_rect(fill="white", 
                                           size=.1, linetype="solid")) + 
    ggtitle(title)
  
  return (plot.out)
}


preprocess.int3 <- function(yhat, var) {
  yhat = as.data.frame(yhat)[,c(1,2,3,6,7)]
  
  yhat$facet = as.numeric(levels(yhat$facet)[as.numeric(yhat$facet)])   #econworsen is factor so need to change to numeric
  yhat = yhat[which(yhat$facet %in% c(min(yhat$facet), max(yhat$facet))), ]  # take one sd below and above the mean for econworsen
  colnames(yhat) = c("Corrupt", "Estimate", "se", "Ulema", var)
  
  yhat[,var] = c(rep(c("Low", "High"), 4))
  yhat$Corrupt = c(rep("No Corruption Info", 4), rep("Corrupt", 4))
  yhat$Ulema = c(rep(c("No Ulema Info", "No Ulema Info", "Bigger Ulema Roles", "Bigger Ulema Roles"), 2))
  
  yhat[,var] = factor(yhat[,var], levels=c("Low", "High"))
  yhat$Corrupt = factor(yhat$Corrupt, levels=c("No Corruption Info", "Corrupt"))
  yhat$Ulema = factor(yhat$Ulema, levels=c("No Ulema Info", "Bigger Ulema Roles"))
  
  yhat.low = yhat[yhat[,var]=="Low",]
  yhat.high = yhat[yhat[,var]=="High",]
  
  return(list(yhat = yhat,
              yhat.low = yhat.low, 
              yhat.high = yhat.high))
}


###################################################################################################################
## MAIN EFFECTS AND INTERACTION BETWEEN MAIN EFFECTS
###################################################################################################################

mod.main.effects = svyglm(vote ~ corrupt + ulema, design = svydat.muslim, family="gaussian")
mod.int.treatments = svyglm(vote ~ corrupt*ulema, design = svydat.muslim, family="gaussian")

logit.main.effects = svyglm(vote ~ corrupt + ulema, design = svydat.muslim, family="quasibinomial")
logit.int.treatments = svyglm(vote ~ corrupt*ulema, design = svydat.muslim, family="quasibinomial")


### Predicted Values: Two-Way Interaction between Ulema and Corruption
yhat = ggpredict(mod.int.treatments, terms = c("corrupt", "ulema"))
yhat = as.data.frame(yhat)[,c(1,2,3,6)]
colnames(yhat) = c("Corrupt", "Estimate", "se", "Ulema")

yhat$Corrupt = c("No Corruption Info", "No Corruption Info", "Corrupt", "Corrupt")
yhat$Ulema = c("No Ulema Info", "Bigger Ulema Roles", "No Ulema Info", "Bigger Ulema Roles")

yhat$Corrupt = factor(yhat$Corrupt, levels=c("No Corruption Info", "Corrupt"))
yhat$Ulema = factor(yhat$Ulema, levels=c("No Ulema Info", "Bigger Ulema Roles"))

plot.main = ggplot(yhat, aes(Corrupt, Estimate, fill=Ulema))
plot.int =  
  plot.int2bar(plot.main, 
            title="Predicted Values by Corruption and Ulema Treatments",
            obj = yhat$Ulema,
            obj.label = "Ulema Treatment",
            pos.legend = c(.85, .8),
            legend.title.size = 11,
            legend.label.size = 10,
            lab.y = "Voting Likelihood",
            ylim = c(min(yhat$Estimate)-.1, max(yhat$Estimate)+.1))


png("Figure Predicted Values (Main Effects).png", width=3000, height=2000, res=300)
print(plot.int)
dev.off()


### Marginal Effect: Main Effect
out = data.frame(summary(mod.main.effects)$coef[c(2,3), c(1,2)])
out = data.frame(cbind(Treatment = c("Corruption\nTreatment", "Ulema\nTreatment"), out))
colnames(out) = c("Treatment", "Estimate", "se")

plot.temp = ggplot(out, aes(Treatment, Estimate))
plot.main.1 = plot.main.effect(plot.temp,
                              title = "Marginal Effects of Corruption and Ulema Treatments",
                              title.size = 10,
                              legend.title.size = 15,
                              lab.y = "Estimate",
                              ylim = c(-.8, .1)) + 
                              geom_hline(yintercept=0, linetype="dashed") + 
                              coord_flip()


### Marginal Effect: Two-way interaction
mod.int.treatments
out = sim_slopes(mod.int.treatments, 
                 pred = corrupt, 
                 modx = ulema, 
                 modx.values = c(0,1),
                 johnson_neyman = FALSE)$slopes[, c(1,2,3)]
colnames(out) = c("Ulema", "Estimate", "se")
out$Ulema = c("No Ulema\nInfo", "Bigger Ulema\nRoles")
out$Ulema = factor(out$Ulema, levels = c("No Ulema\nInfo", "Bigger Ulema\nRoles"))

plot.temp = ggplot(out, aes(Ulema, Estimate))

plot.main.2 = plot.main.effect(plot.temp,
                              title = "Marginal Effect of Corruption by Ulema Treatment",
                              title.size = 10,
                              legend.title.size = 15,
                              lab.y = "Estimate",
                              ylim = c(-.8, .1)) + 
                              geom_hline(yintercept=0, linetype="dashed") + 
                              coord_flip()

png("Figure Marginal Effects (Main Effects).png", width=3000, height=2000, res=300)
print((plot.main.1 + plot.main.2))
dev.off()


png("Figure Predicted and Marginal (Main Effects).png", width=3000, height=2000, res=300)
print(plot.int/(plot.main.1 + plot.main.2))
dev.off()


# ###################################################################################################################
# ## ROBUSTNESS WITH RELIGIOSITY AND POLITICAL ISLAM
# ###################################################################################################################

## Religiosity (Political Islam)
mod.int2.considerrel = svyglm(vote ~ corrupt*considerrel + ulema*considerrel, 
                              design = svydat.muslim, family="gaussian")
logit.int2.considerrel = svyglm(vote ~ corrupt*considerrel + ulema*considerrel, 
                                design = svydat.muslim, family="quasibinomial")

mod.int3.considerrel = svyglm(vote ~ corrupt*ulema*considerrel, 
                              design = svydat.muslim, family="gaussian")
logit.int3.considerrel = svyglm(vote ~ corrupt*ulema*considerrel, 
                                design = svydat.muslim, family="quasibinomial")


## Islamic Party
mod.int2.islamicparty = svyglm(vote ~ corrupt*islamicparty2019 + ulema*islamicparty2019, 
                           design = svydat.muslim, family="gaussian")
logit.int2.islamicparty = svyglm(vote ~ corrupt*islamicparty2019 + ulema*islamicparty2019, 
                             design = svydat.muslim, family="quasibinomial")

mod.int3.islamicparty = svyglm(vote ~ corrupt*ulema*islamicparty2019, 
                           design = svydat.muslim, family="gaussian")
logit.int3.islamicparty = svyglm(vote ~ corrupt*ulema*islamicparty2019, 
                             design = svydat.muslim, family="quasibinomial")


# ###################################################################################################################
# ## ROBUSTNESS WITH DEMOGRAPHIC VARIABLES (GENDER, EDUCATION, JAVA NON-JAVA)
# ###################################################################################################################

cov.main.effects = svyglm(vote ~ female + edu + age + income + javaisland + urban + 
                            corrupt + ulema, design = svydat.muslim, family="gaussian")
cov.int.treatments = svyglm(vote ~ female + edu + age + income + javaisland + urban + 
                              corrupt*ulema, design = svydat.muslim, family="gaussian")



# ###################################################################################################################
# ## ROBUSTNESS WITH AUGUST 2020 SURVEY DATA (SUPPORT FOR SHARIA)
# ###################################################################################################################

source("Robustness Endorsing Sharia.R")

mod.aug.main = svyglm(dvvote ~ sharia, design = svydat_aug.muslim, family="gaussian")
mod.aug.considerrel = svyglm(dvvote ~ sharia*considerrel, 
                             design = svydat_aug.muslim, family="gaussian")

logit.aug.main = svyglm(dvvote ~ sharia, design = svydat_aug.muslim, family="quasibinomial")
logit.aug.considerrel = svyglm(dvvote ~ sharia*considerrel, 
                             design = svydat_aug.muslim, family="quasibinomial")


cov.aug.main = svyglm(dvvote ~ female + edu + age + income + javaisland + desakota +
                        sharia, design = svydat_aug.muslim, family="gaussian")


# ###################################################################################################################
# ## WRITING OUT REGRESSION ANALYSIS
# ###################################################################################################################

tab_model(mod.main.effects,
          mod.int.treatments,
          
          mod.int2.considerrel,
          mod.int3.considerrel, 
          
          mod.int2.islamicparty,
          mod.int3.islamicparty, 
          
          mod.aug.main,
          mod.aug.considerrel,
          
          cov.main.effects,
          cov.int.treatments,
          cov.aug.main,
          
          show.se = TRUE, collapse.se = TRUE,
          digits = 3,
          p.val = "wald",
          p.style = "stars",
          show.ci = FALSE, show.p = FALSE, transform = NULL,
          file="Regression Models OLS.htm")


tab_model(logit.main.effects,
          logit.int.treatments,
          
          logit.int2.considerrel,
          logit.int3.considerrel, 
          
          logit.int2.islamicparty,
          logit.int3.islamicparty, 
          
          logit.aug.main,
          logit.aug.considerrel,
          
          show.se = TRUE, collapse.se = TRUE,
          digits = 3,
          p.val = "wald",
          p.style = "stars",
          show.ci = FALSE, show.p = FALSE, transform = NULL,
          file="Regression Models Logit.htm")

